'
' Instances of this class represent undo commands.
'
<Undo()> Public Class UndoCommand
    Implements ICommand

    '
    ' This implementation of doIt does not actually do anything.
    ' The logic for undo is in the CommandManager class.  A
    ' CommandManager object knows that it is supposed to invoke
    ' its undo logic when it sees an instace of this class
    ' because this class implments the Undo interface.  The Undo
    ' interface is a semantic interface that is used to mark a
    ' class as representing an undo command.
    '
    Public Function DoIt() As Boolean _
        Implements ICommand.DoIt
        ' This method should never be called
        Throw New System.NotImplementedException()
    End Function

    '
    ' This implementation of undoIt does not actually do
    ' anything.  Undo commands are not undone.  Instead a redo
    ' command is issued.
    '
    Public Function UndoIt() As Boolean _
        Implements ICommand.UndoIt
        ' This method should never be called
        Throw New System.NotImplementedException()
    End Function

End Class 'UndoCommand 
